package org.msh.tb.bd.tbforms.indicator;

import org.jboss.seam.Component;
import org.jboss.seam.annotations.Name;
import org.msh.tb.bd.Quarter;
import org.msh.tb.entities.Tbunit;
import org.msh.tb.entities.UserWorkspace;
import org.msh.tb.indicators.core.IndicatorFilters;
import org.msh.tb.login.UserSession;

/**
 * Created by mauri on 30/06/2017.
 */
@Name("tBFormUnitReport")
public class TBFormUnitReport {

    IndicatorFilters indicatorFilter;

    public void initialize(boolean checkQuarter) {
        UserWorkspace uw = UserSession.getUserWorkspace();
        getIndicatorFilters().getTbunitselection().getAuselection().setSelectedUnit(uw.getTbunit().getAdminUnit());
        getIndicatorFilters().getTbunitselection().setSelected(uw.getTbunit());

        if (getTbunit() == null) {
            throw new RuntimeException("Tbunit can't me null.");
        }

        if (checkQuarter && (getQuarter() == null || getQuarter().getQuarter() == null || getQuarter().getYear() == 0)) {
            throw new RuntimeException("Quarter can't be null");
        }

        if(!checkQuarter && getQuarter() == null){
            getIndicatorFilters().setQuarterMonths(Quarter.getCurrentQuarter().getQuarter());
            getIndicatorFilters().setQuarterYear(Quarter.getCurrentQuarter().getYear());
        }
    }

    public Tbunit getTbunit() {
        return getIndicatorFilters().getTbunitselection().getSelected();
    }

    public Quarter getQuarter() {
        return getIndicatorFilters().getQuarter();
    }

    /**
     * Return the filters selected by the user
     * @return instance of the {@link IndicatorFilters IndicatorFilters} class
     */
    protected IndicatorFilters getIndicatorFilters() {
        if (indicatorFilter == null)
            indicatorFilter = (IndicatorFilters) Component.getInstance("indicatorFilters");
        return indicatorFilter;
    }
}
